﻿//////////////////////////////////////////////
// NunitOutputFormatter.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkDebug
{
	class TestClassObserverInformation ;
	class TestFunctionObserverInformation ;
}

/// Includes ---------------------------------

// nkDebug
#include "../../Dll/DllDefines.h"

#include "OutputFormatter.h"

/// Class ------------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT NunitOutputFormatter final : public OutputFormatter
	{
		public :

			// Constructor, destructor
			NunitOutputFormatter () noexcept ;
			virtual ~NunitOutputFormatter () ;

			// Formatting
			virtual nkMemory::String formatRunLaunch (const TestRunParameters& params) override ;
			virtual nkMemory::String formatRunEnd () override ;
			virtual nkMemory::String formatClassLaunch (const TestClassObserverInformation& info) override ;
			virtual nkMemory::String formatClassBypass (const TestClassObserverInformation& info) override ;
			virtual nkMemory::String formatClassEnd (const TestClassObserverInformation& info) override ;
			virtual nkMemory::String formatTestLaunch (const TestFunctionObserverInformation& info) override ;
			virtual nkMemory::String formatTestBypass (const TestFunctionObserverInformation& info) override ;
			virtual nkMemory::String formatTestSuccess (const TestFunctionObserverInformation& info) override ;
			virtual nkMemory::String formatTestFailure (const TestFunctionObserverInformation& info) override ;

		private :

			// Functions
			// Formatting
			void _formatTestResult (const TestFunctionObserverInformation& info, int result) ;

		private :

			// Attributes
			nkMemory::String _reportBody ;

			nkMemory::String _suiteBody ;

			nkMemory::String _currentClassName ;

			nkMemory::String _runDate ;
			nkMemory::String _startTime ;

			unsigned int _classCounter ;
			unsigned int _testCounter ;
			unsigned int _totalTestCounter ;

			unsigned int _passedTestCounter ;
			unsigned int _failedTestCounter ;
			unsigned int _skippedTestCounter ;

			unsigned int _suitePassedTestCounter ;
			unsigned int _suiteFailedTestCounter ;
			unsigned int _suiteSkippedTestCounter ;

			unsigned long long _totalTimeMicroS ;
	} ;
}